Attribute VB_Name = "IDAutomation_Native_QRCode_VBA_DEMO"
'*********************************************************************
' IDAutomation Native Barcode Generator 2016 DEMO
'  Copyright 2016, IDAutomation.com, Inc. All rights reserved.
'
' DEMO VERSION NOTICE:
' The demo version of this product contains a small static barcode that may be
' used for evaluation purposes only to prove functionality.
' The static barcode cannot be changed because this would reveal the
' complete VBA formula, which is only available in the purchased version.
' For testing and evaluation purposes, only the following properties may be changed:
' TextControlName, ReportControlName, MILS, DPI & Orientation.
'
' The fully functional purchased version is provided with a 30 day
' money back satisfaction guarantee. If it is necessary to test dynamic
' barcodes with this product, the purchased version is required.
'
' Purchase Link:
' http://www.idautomation.com/barcode-components/access-native/#licensing
'
' User Manual and Tutorial:
' http://www.idautomation.com/barcode-components/access-native/user-manual.html
'
' For testing and evaluation purposes, only the following properties may be changed:
' TextControlName, ReportControlName, MILS, DPI & Orientation.
'
'*********************************************************************

Option Compare Database
Option Explicit
   
   'This is the main QR-CodeEncoder class that generates the QR-CodeEncoder barcode image.
      Private DEMO As Integer
      Private DECount As Integer
      Dim currentX As Integer
      Dim currentY As Integer
      Dim processTilde As Integer
      Dim code As String
      Dim propPreferredFormat As Integer
      Private CurrentValue As Long
      Private WeightValue As Long
      Private Factor As Long
      Private XPixles As Long
      Private CanvasCurrentX As Long
      Private CanvasCurrentY As Long
      Private CanvasTop As Long
      Private CanvasHeight As Long
      Private G As Long
      Private CanvasWidth As Long
   
      Public reBuild As Boolean
      Private internalCode As String
          
          
          
     Private resultBitmap(22, 22) As Integer
      Const ConstROW As Integer = 0
      Const ConstCOL As Integer = 1
      Const ConstROWDATA As Integer = 2
      Const ConstCOLDATA As Integer = 3
      Const ConstREGIONS As Integer = 4
      Const ConstROWMAP As Integer = 5
      Const ConstCOLMAP As Integer = 6
      Const ConstTOTALDATA As Integer = 7
      Const ConstTOTALERR As Integer = 8
      Const ConstREEDDATA As Integer = 9
      Const ConstREEDERR As Integer = 10
      Const ConstREEDBLOCKS As Integer = 11
      
      ' different configurations
      Const C10X10 As Integer = 0
      Const C12X12 As Integer = 1
      Const C14X14 As Integer = 2
      Const C16X16 As Integer = 3
      Const C18X18 As Integer = 4
      Const C20X20 As Integer = 5
      Const C22X22 As Integer = 6
      Const C24X24 As Integer = 7
      Const C26X26 As Integer = 8
      Const C32X32 As Integer = 9
      Const C36X36 As Integer = 10
      Const C40X40 As Integer = 11
      Const C44X44 As Integer = 12
      Const C48X48 As Integer = 13
      Const C52X52 As Integer = 14
      Const C64X64 As Integer = 15
      Const C72X72 As Integer = 16
      Const C80X80 As Integer = 17
      Const C88X88 As Integer = 18
      Const C96X96 As Integer = 19
      Const C104X104 As Integer = 20
      Const C120X120 As Integer = 21
      Const C132X132 As Integer = 22
      Const C144X144 As Integer = 23
      Const C8X18 As Integer = 24
      Const C8X32 As Integer = 25
      Const C12X26 As Integer = 26
      Const C12X36 As Integer = 27
      Const C16X36 As Integer = 28
      Const C16X48 As Integer = 29
      
      ' QR-Code codes
      Const C40_PAD As Integer = 0
      Const PAD As Integer = 129
      Const LATCH_C40 As Integer = 230
      Const LATCH_BASE256 As Integer = 231
      Const FNC1 As Integer = 232
      Const STRUCTURED_APPEND As Integer = 233
      Const READER_PROGRAMMING As Integer = 234
      Const SHIFT As Integer = 235
      Const MACRO5 As Integer = 236
      Const MACRO6 As Integer = 237
      Const LATCH_TEXT As Integer = 239
      Const ECI As Integer = 241
      Const UNLATCH As Integer = 254
      Private currentEncoding As Integer
      
      ' symbol attributtes of the configurations
      Private configuration(30, 12) As Integer
      Dim rows As Integer
      Dim cols As Integer
      Dim datarows As Integer
      Dim datacols As Integer
      Dim maprows As Integer
      Dim mapcols As Integer
      Dim regions As Integer
      Dim totaldata As Integer
      Dim totalerr As Integer
      Dim reeddata As Integer
      Dim reederr As Integer
      Dim reedblocks As Integer
      Private C49rest As Integer
      Dim C40Codes(256, 4) As Integer
    
         'charPlacer variables
         Dim nrow As Integer
         Dim ncol As Integer
         Dim array1() As Integer
         Dim array1Length As Integer
         Dim rowString As String
         Dim colString As String
         Dim chrString As String
        'reed variables
        Dim gfi(255) As Integer
        Dim gflog(256) As Integer
        Public KReed As Integer
        Dim n As Integer
        Dim p() As Integer
        Dim p5(5) As Integer
        Dim p7(7) As Integer
        Dim p10(10) As Integer
        Dim p11(11) As Integer
        Dim p12(12) As Integer
        Dim p14(14) As Integer
        Dim p18(18) As Integer
        Dim p20(20) As Integer
        Dim p24(24) As Integer
        Dim p28(28) As Integer
        Dim p36(36) As Integer
        Dim p42(42) As Integer
        Dim p48(48) As Integer
        Dim p56(56) As Integer
        Dim p62(62) As Integer
        Dim p68(68) As Integer
        
        
Public Function IDAutomation_NatG_QRCode_DEMO(TextControlName As Control, ReportControlName As Report, Optional Mils As Long = 20, Optional DPI As Long = 300, Optional ApplyTilde As Integer = 0, Optional EncodingMode As Integer = 0, Optional preferredFormat As Integer = -1, Optional Orientation As Long = 0)
    
    'DEMO Message
    If DEMO <> 3 Or DECount = 37 Then
        DECount = 1
        MsgBox "The demo version of this product contains a single very small static barcode that may be used for evaluation purposes only to prove functionality. The static barcode cannot be changed because this would reveal the complete VBA formula, which is only available in the licensed version. The fully functional licensed version is provided with a 30 day money back satisfaction guarantee. To purchase the license please visit:" & vbCrLf & "www.idautomation.com/barcode-components/access-native/ ", , "IDAutomation Demo Notice"
        DEMO = 3
    End If
    DECount = DECount + 1
    
    resultBitmap(0, 0) = 1
    resultBitmap(0, 1) = 1
    resultBitmap(0, 2) = 1
    resultBitmap(0, 3) = 1
    resultBitmap(0, 4) = 1
    resultBitmap(0, 5) = 1
    resultBitmap(0, 6) = 1
    resultBitmap(0, 7) = 0
    resultBitmap(0, 8) = 1
    resultBitmap(0, 9) = 0
    resultBitmap(0, 10) = 0
    resultBitmap(0, 11) = 0
    resultBitmap(0, 12) = 1
    resultBitmap(0, 13) = 0
    resultBitmap(0, 14) = 1
    resultBitmap(0, 15) = 1
    resultBitmap(0, 16) = 1
    resultBitmap(0, 17) = 1
    resultBitmap(0, 18) = 1
    resultBitmap(0, 19) = 1
    resultBitmap(0, 20) = 1
    resultBitmap(0, 21) = 0
    
    resultBitmap(1, 0) = 1
    resultBitmap(1, 1) = 0
    resultBitmap(1, 2) = 0
    resultBitmap(1, 3) = 0
    resultBitmap(1, 4) = 0
    resultBitmap(1, 5) = 0
    resultBitmap(1, 6) = 1
    resultBitmap(1, 7) = 0
    resultBitmap(1, 8) = 1
    resultBitmap(1, 9) = 0
    resultBitmap(1, 10) = 1
    resultBitmap(1, 11) = 0
    resultBitmap(1, 12) = 0
    resultBitmap(1, 13) = 0
    resultBitmap(1, 14) = 1
    resultBitmap(1, 15) = 0
    resultBitmap(1, 16) = 0
    resultBitmap(1, 17) = 0
    resultBitmap(1, 18) = 0
    resultBitmap(1, 19) = 0
    resultBitmap(1, 20) = 1
    resultBitmap(1, 21) = 0
    
    resultBitmap(2, 0) = 1
    resultBitmap(2, 1) = 0
    resultBitmap(2, 2) = 1
    resultBitmap(2, 3) = 1
    resultBitmap(2, 4) = 1
    resultBitmap(2, 5) = 0
    resultBitmap(2, 6) = 1
    resultBitmap(2, 7) = 0
    resultBitmap(2, 8) = 1
    resultBitmap(2, 9) = 1
    resultBitmap(2, 10) = 0
    resultBitmap(2, 11) = 0
    resultBitmap(2, 12) = 0
    resultBitmap(2, 13) = 0
    resultBitmap(2, 14) = 1
    resultBitmap(2, 15) = 0
    resultBitmap(2, 16) = 1
    resultBitmap(2, 17) = 1
    resultBitmap(2, 18) = 1
    resultBitmap(2, 19) = 0
    resultBitmap(2, 20) = 1
    resultBitmap(2, 21) = 0
    
    resultBitmap(3, 0) = 1
    resultBitmap(3, 1) = 0
    resultBitmap(3, 2) = 1
    resultBitmap(3, 3) = 1
    resultBitmap(3, 4) = 1
    resultBitmap(3, 5) = 0
    resultBitmap(3, 6) = 1
    resultBitmap(3, 7) = 0
    resultBitmap(3, 8) = 1
    resultBitmap(3, 9) = 1
    resultBitmap(3, 10) = 0
    resultBitmap(3, 11) = 0
    resultBitmap(3, 12) = 0
    resultBitmap(3, 13) = 0
    resultBitmap(3, 14) = 1
    resultBitmap(3, 15) = 0
    resultBitmap(3, 16) = 1
    resultBitmap(3, 17) = 1
    resultBitmap(3, 18) = 1
    resultBitmap(3, 19) = 0
    resultBitmap(3, 20) = 1
    resultBitmap(3, 21) = 0
    
    resultBitmap(4, 0) = 1
    resultBitmap(4, 1) = 0
    resultBitmap(4, 2) = 1
    resultBitmap(4, 3) = 1
    resultBitmap(4, 4) = 1
    resultBitmap(4, 5) = 0
    resultBitmap(4, 6) = 1
    resultBitmap(4, 7) = 0
    resultBitmap(4, 8) = 1
    resultBitmap(4, 9) = 0
    resultBitmap(4, 10) = 0
    resultBitmap(4, 11) = 1
    resultBitmap(4, 12) = 1
    resultBitmap(4, 13) = 0
    resultBitmap(4, 14) = 1
    resultBitmap(4, 15) = 0
    resultBitmap(4, 16) = 1
    resultBitmap(4, 17) = 1
    resultBitmap(4, 18) = 1
    resultBitmap(4, 19) = 0
    resultBitmap(4, 20) = 1
    resultBitmap(4, 21) = 0
    
    resultBitmap(5, 0) = 1
    resultBitmap(5, 1) = 0
    resultBitmap(5, 2) = 0
    resultBitmap(5, 3) = 0
    resultBitmap(5, 4) = 0
    resultBitmap(5, 5) = 0
    resultBitmap(5, 6) = 1
    resultBitmap(5, 7) = 0
    resultBitmap(5, 8) = 0
    resultBitmap(5, 9) = 1
    resultBitmap(5, 10) = 1
    resultBitmap(5, 11) = 1
    resultBitmap(5, 12) = 0
    resultBitmap(5, 13) = 0
    resultBitmap(5, 14) = 1
    resultBitmap(5, 15) = 0
    resultBitmap(5, 16) = 0
    resultBitmap(5, 17) = 0
    resultBitmap(5, 18) = 0
    resultBitmap(5, 19) = 0
    resultBitmap(5, 20) = 1
    resultBitmap(5, 21) = 0
    
    resultBitmap(6, 0) = 1
    resultBitmap(6, 1) = 1
    resultBitmap(6, 2) = 1
    resultBitmap(6, 3) = 1
    resultBitmap(6, 4) = 1
    resultBitmap(6, 5) = 1
    resultBitmap(6, 6) = 1
    resultBitmap(6, 7) = 0
    resultBitmap(6, 8) = 1
    resultBitmap(6, 9) = 0
    resultBitmap(6, 10) = 1
    resultBitmap(6, 11) = 0
    resultBitmap(6, 12) = 1
    resultBitmap(6, 13) = 0
    resultBitmap(6, 14) = 1
    resultBitmap(6, 15) = 1
    resultBitmap(6, 16) = 1
    resultBitmap(6, 17) = 1
    resultBitmap(6, 18) = 1
    resultBitmap(6, 19) = 1
    resultBitmap(6, 20) = 1
    resultBitmap(6, 21) = 0
    
    resultBitmap(7, 0) = 0
    resultBitmap(7, 1) = 0
    resultBitmap(7, 2) = 0
    resultBitmap(7, 3) = 0
    resultBitmap(7, 4) = 0
    resultBitmap(7, 5) = 0
    resultBitmap(7, 6) = 0
    resultBitmap(7, 7) = 0
    resultBitmap(7, 8) = 1
    resultBitmap(7, 9) = 0
    resultBitmap(7, 10) = 1
    resultBitmap(7, 11) = 1
    resultBitmap(7, 12) = 1
    resultBitmap(7, 13) = 0
    resultBitmap(7, 14) = 0
    resultBitmap(7, 15) = 0
    resultBitmap(7, 16) = 0
    resultBitmap(7, 17) = 0
    resultBitmap(7, 18) = 0
    resultBitmap(7, 19) = 0
    resultBitmap(7, 20) = 0
    resultBitmap(7, 21) = 0
    
    resultBitmap(8, 0) = 0
    resultBitmap(8, 1) = 1
    resultBitmap(8, 2) = 0
    resultBitmap(8, 3) = 1
    resultBitmap(8, 4) = 0
    resultBitmap(8, 5) = 1
    resultBitmap(8, 6) = 1
    resultBitmap(8, 7) = 0
    resultBitmap(8, 8) = 1
    resultBitmap(8, 9) = 1
    resultBitmap(8, 10) = 0
    resultBitmap(8, 11) = 1
    resultBitmap(8, 12) = 1
    resultBitmap(8, 13) = 1
    resultBitmap(8, 14) = 1
    resultBitmap(8, 15) = 0
    resultBitmap(8, 16) = 1
    resultBitmap(8, 17) = 1
    resultBitmap(8, 18) = 1
    resultBitmap(8, 19) = 1
    resultBitmap(8, 20) = 1
    resultBitmap(8, 21) = 0
    
    resultBitmap(9, 0) = 0
    resultBitmap(9, 1) = 1
    resultBitmap(9, 2) = 0
    resultBitmap(9, 3) = 1
    resultBitmap(9, 4) = 1
    resultBitmap(9, 5) = 0
    resultBitmap(9, 6) = 0
    resultBitmap(9, 7) = 1
    resultBitmap(9, 8) = 0
    resultBitmap(9, 9) = 1
    resultBitmap(9, 10) = 0
    resultBitmap(9, 11) = 0
    resultBitmap(9, 12) = 1
    resultBitmap(9, 13) = 0
    resultBitmap(9, 14) = 0
    resultBitmap(9, 15) = 0
    resultBitmap(9, 16) = 1
    resultBitmap(9, 17) = 0
    resultBitmap(9, 18) = 0
    resultBitmap(9, 19) = 0
    resultBitmap(9, 20) = 0
    resultBitmap(9, 21) = 0
    
    resultBitmap(10, 0) = 1
    resultBitmap(10, 1) = 1
    resultBitmap(10, 2) = 1
    resultBitmap(10, 3) = 0
    resultBitmap(10, 4) = 0
    resultBitmap(10, 5) = 0
    resultBitmap(10, 6) = 1
    resultBitmap(10, 7) = 0
    resultBitmap(10, 8) = 0
    resultBitmap(10, 9) = 0
    resultBitmap(10, 10) = 0
    resultBitmap(10, 11) = 1
    resultBitmap(10, 12) = 0
    resultBitmap(10, 13) = 1
    resultBitmap(10, 14) = 1
    resultBitmap(10, 15) = 0
    resultBitmap(10, 16) = 0
    resultBitmap(10, 17) = 0
    resultBitmap(10, 18) = 1
    resultBitmap(10, 19) = 0
    resultBitmap(10, 20) = 1
    resultBitmap(10, 21) = 0
    
    resultBitmap(11, 0) = 1
    resultBitmap(11, 1) = 0
    resultBitmap(11, 2) = 1
    resultBitmap(11, 3) = 0
    resultBitmap(11, 4) = 0
    resultBitmap(11, 5) = 1
    resultBitmap(11, 6) = 0
    resultBitmap(11, 7) = 0
    resultBitmap(11, 8) = 1
    resultBitmap(11, 9) = 1
    resultBitmap(11, 10) = 0
    resultBitmap(11, 11) = 1
    resultBitmap(11, 12) = 0
    resultBitmap(11, 13) = 0
    resultBitmap(11, 14) = 1
    resultBitmap(11, 15) = 0
    resultBitmap(11, 16) = 1
    resultBitmap(11, 17) = 1
    resultBitmap(11, 18) = 0
    resultBitmap(11, 19) = 1
    resultBitmap(11, 20) = 0
    resultBitmap(11, 21) = 0
    
    resultBitmap(12, 0) = 1
    resultBitmap(12, 1) = 1
    resultBitmap(12, 2) = 1
    resultBitmap(12, 3) = 1
    resultBitmap(12, 4) = 1
    resultBitmap(12, 5) = 0
    resultBitmap(12, 6) = 1
    resultBitmap(12, 7) = 0
    resultBitmap(12, 8) = 0
    resultBitmap(12, 9) = 1
    resultBitmap(12, 10) = 1
    resultBitmap(12, 11) = 1
    resultBitmap(12, 12) = 1
    resultBitmap(12, 13) = 1
    resultBitmap(12, 14) = 0
    resultBitmap(12, 15) = 0
    resultBitmap(12, 16) = 0
    resultBitmap(12, 17) = 1
    resultBitmap(12, 18) = 1
    resultBitmap(12, 19) = 1
    resultBitmap(12, 20) = 1
    resultBitmap(12, 21) = 0
    
    resultBitmap(13, 0) = 0
    resultBitmap(13, 1) = 0
    resultBitmap(13, 2) = 0
    resultBitmap(13, 3) = 0
    resultBitmap(13, 4) = 0
    resultBitmap(13, 5) = 0
    resultBitmap(13, 6) = 0
    resultBitmap(13, 7) = 0
    resultBitmap(13, 8) = 1
    resultBitmap(13, 9) = 0
    resultBitmap(13, 10) = 1
    resultBitmap(13, 11) = 1
    resultBitmap(13, 12) = 0
    resultBitmap(13, 13) = 0
    resultBitmap(13, 14) = 0
    resultBitmap(13, 15) = 0
    resultBitmap(13, 16) = 0
    resultBitmap(13, 17) = 1
    resultBitmap(13, 18) = 0
    resultBitmap(13, 19) = 1
    resultBitmap(13, 20) = 0
    resultBitmap(13, 21) = 0
    
    resultBitmap(14, 0) = 1
    resultBitmap(14, 1) = 1
    resultBitmap(14, 2) = 1
    resultBitmap(14, 3) = 1
    resultBitmap(14, 4) = 1
    resultBitmap(14, 5) = 1
    resultBitmap(14, 6) = 1
    resultBitmap(14, 7) = 0
    resultBitmap(14, 8) = 0
    resultBitmap(14, 9) = 1
    resultBitmap(14, 10) = 0
    resultBitmap(14, 11) = 1
    resultBitmap(14, 12) = 1
    resultBitmap(14, 13) = 0
    resultBitmap(14, 14) = 0
    resultBitmap(14, 15) = 0
    resultBitmap(14, 16) = 0
    resultBitmap(14, 17) = 1
    resultBitmap(14, 18) = 1
    resultBitmap(14, 19) = 1
    resultBitmap(14, 20) = 0
    resultBitmap(14, 21) = 0
    
    resultBitmap(15, 0) = 1
    resultBitmap(15, 1) = 0
    resultBitmap(15, 2) = 0
    resultBitmap(15, 3) = 0
    resultBitmap(15, 4) = 0
    resultBitmap(15, 5) = 0
    resultBitmap(15, 6) = 1
    resultBitmap(15, 7) = 0
    resultBitmap(15, 8) = 1
    resultBitmap(15, 9) = 1
    resultBitmap(15, 10) = 1
    resultBitmap(15, 11) = 0
    resultBitmap(15, 12) = 1
    resultBitmap(15, 13) = 1
    resultBitmap(15, 14) = 1
    resultBitmap(15, 15) = 0
    resultBitmap(15, 16) = 0
    resultBitmap(15, 17) = 1
    resultBitmap(15, 18) = 0
    resultBitmap(15, 19) = 0
    resultBitmap(15, 20) = 0
    resultBitmap(15, 21) = 0
    
    resultBitmap(16, 0) = 1
    resultBitmap(16, 1) = 0
    resultBitmap(16, 2) = 1
    resultBitmap(16, 3) = 1
    resultBitmap(16, 4) = 1
    resultBitmap(16, 5) = 0
    resultBitmap(16, 6) = 1
    resultBitmap(16, 7) = 0
    resultBitmap(16, 8) = 0
    resultBitmap(16, 9) = 0
    resultBitmap(16, 10) = 1
    resultBitmap(16, 11) = 1
    resultBitmap(16, 12) = 1
    resultBitmap(16, 13) = 1
    resultBitmap(16, 14) = 0
    resultBitmap(16, 15) = 0
    resultBitmap(16, 16) = 0
    resultBitmap(16, 17) = 0
    resultBitmap(16, 18) = 0
    resultBitmap(16, 19) = 1
    resultBitmap(16, 20) = 1
    resultBitmap(16, 21) = 0
    
    resultBitmap(17, 0) = 1
    resultBitmap(17, 1) = 0
    resultBitmap(17, 2) = 1
    resultBitmap(17, 3) = 1
    resultBitmap(17, 4) = 1
    resultBitmap(17, 5) = 0
    resultBitmap(17, 6) = 1
    resultBitmap(17, 7) = 0
    resultBitmap(17, 8) = 1
    resultBitmap(17, 9) = 0
    resultBitmap(17, 10) = 1
    resultBitmap(17, 11) = 1
    resultBitmap(17, 12) = 0
    resultBitmap(17, 13) = 0
    resultBitmap(17, 14) = 1
    resultBitmap(17, 15) = 1
    resultBitmap(17, 16) = 0
    resultBitmap(17, 17) = 1
    resultBitmap(17, 18) = 0
    resultBitmap(17, 19) = 1
    resultBitmap(17, 20) = 1
    resultBitmap(17, 21) = 0
    
    resultBitmap(18, 0) = 1
    resultBitmap(18, 1) = 0
    resultBitmap(18, 2) = 1
    resultBitmap(18, 3) = 1
    resultBitmap(18, 4) = 1
    resultBitmap(18, 5) = 0
    resultBitmap(18, 6) = 1
    resultBitmap(18, 7) = 0
    resultBitmap(18, 8) = 0
    resultBitmap(18, 9) = 1
    resultBitmap(18, 10) = 0
    resultBitmap(18, 11) = 0
    resultBitmap(18, 12) = 1
    resultBitmap(18, 13) = 1
    resultBitmap(18, 14) = 1
    resultBitmap(18, 15) = 1
    resultBitmap(18, 16) = 1
    resultBitmap(18, 17) = 0
    resultBitmap(18, 18) = 1
    resultBitmap(18, 19) = 1
    resultBitmap(18, 20) = 1
    resultBitmap(18, 21) = 0
    
    resultBitmap(19, 0) = 1
    resultBitmap(19, 1) = 0
    resultBitmap(19, 2) = 0
    resultBitmap(19, 3) = 0
    resultBitmap(19, 4) = 0
    resultBitmap(19, 5) = 0
    resultBitmap(19, 6) = 1
    resultBitmap(19, 7) = 0
    resultBitmap(19, 8) = 1
    resultBitmap(19, 9) = 1
    resultBitmap(19, 10) = 1
    resultBitmap(19, 11) = 1
    resultBitmap(19, 12) = 0
    resultBitmap(19, 13) = 1
    resultBitmap(19, 14) = 0
    resultBitmap(19, 15) = 0
    resultBitmap(19, 16) = 1
    resultBitmap(19, 17) = 0
    resultBitmap(19, 18) = 0
    resultBitmap(19, 19) = 0
    resultBitmap(19, 20) = 0
    resultBitmap(19, 21) = 0
    
    resultBitmap(20, 0) = 1
    resultBitmap(20, 1) = 1
    resultBitmap(20, 2) = 1
    resultBitmap(20, 3) = 1
    resultBitmap(20, 4) = 1
    resultBitmap(20, 5) = 1
    resultBitmap(20, 6) = 1
    resultBitmap(20, 7) = 0
    resultBitmap(20, 8) = 0
    resultBitmap(20, 9) = 1
    resultBitmap(20, 10) = 1
    resultBitmap(20, 11) = 0
    resultBitmap(20, 12) = 0
    resultBitmap(20, 13) = 1
    resultBitmap(20, 14) = 0
    resultBitmap(20, 15) = 1
    resultBitmap(20, 16) = 0
    resultBitmap(20, 17) = 0
    resultBitmap(20, 18) = 0
    resultBitmap(20, 19) = 1
    resultBitmap(20, 20) = 0
    resultBitmap(20, 21) = 0
    
    resultBitmap(21, 0) = 0
    resultBitmap(21, 1) = 0
    resultBitmap(21, 2) = 0
    resultBitmap(21, 3) = 0
    resultBitmap(21, 4) = 0
    resultBitmap(21, 5) = 0
    resultBitmap(21, 6) = 0
    resultBitmap(21, 7) = 0
    resultBitmap(21, 8) = 0
    resultBitmap(21, 9) = 0
    resultBitmap(21, 10) = 0
    resultBitmap(21, 11) = 0
    resultBitmap(21, 12) = 0
    resultBitmap(21, 13) = 0
    resultBitmap(21, 14) = 0
    resultBitmap(21, 15) = 0
    resultBitmap(21, 16) = 0
    resultBitmap(21, 17) = 0
    resultBitmap(21, 18) = 0
    resultBitmap(21, 19) = 0
    resultBitmap(21, 20) = 0
    resultBitmap(21, 21) = 0
    
    cols = 21
    rows = 21

    If DPI < 301 And Mils < 8 Then Mils = 8
    If DPI < 204 And Mils < 12 Then Mils = 12
    'Convert Mils to Twips in CurrentValue:
    CurrentValue = Mils * 1.44
    'The following formulas match the value in twips with the resolution of
    'the printer as best as possible to create the highest quality symbol:
    WeightValue = CInt(1000 * (1000 / DPI))
    Factor = (CurrentValue * 1000) Mod WeightValue
    If Factor <> 0 Then
       XPixles = CInt(CurrentValue + ((WeightValue - Factor) / 1000))
    Else
       XPixles = CInt(CurrentValue)
    End If
    'Determine the location and size of the TextControl:
    CanvasCurrentX = TextControlName.Left
    CanvasTop = TextControlName.Top
    CanvasHeight = TextControlName.Height
    CanvasCurrentY = CanvasTop
    CanvasWidth = TextControlName.Width
    If Orientation = 270 Then
        'CanvasCurrentX = TextControlName.Left
        CanvasCurrentY = CanvasTop + CanvasHeight
    ElseIf Orientation = 90 Then
        CanvasCurrentX = TextControlName.Left + CanvasWidth
    End If
    'The Visible property must be set to false to keep the text from appearing in the TextControl:
    TextControlName.Visible = False
    'The symbol is painted 1 row at a time from left to right
    Dim j1 As Integer
    Dim i1 As Integer
    For j1 = 0 To rows - 1
         If Orientation = 0 Then
            CanvasCurrentX = TextControlName.Left
            For i1 = 0 To cols - 1
               If resultBitmap(i1, j1) = 0 Then 'it is a "WHITE" square
                 ReportControlName.Line (CanvasCurrentX, CanvasCurrentY)-Step(XPixles, -XPixles), 16777215, BF
               Else                       'it is a "BLACK" square
                 ReportControlName.Line (CanvasCurrentX, CanvasCurrentY)-Step(XPixles, -XPixles), 0, BF
               End If                     'Next Column
               CanvasCurrentX = CanvasCurrentX + XPixles
            Next i1 'Next Row
            CanvasCurrentY = CanvasCurrentY + XPixles
        ElseIf Orientation = 90 Then
            For i1 = 0 To cols - 1
               If resultBitmap(i1, j1) = 0 Then 'it is a "WHITE" square
                 ReportControlName.Line (CanvasCurrentX, CanvasCurrentY)-Step(-XPixles, XPixles), 16777215, BF
               Else                       'it is a "BLACK" square
                 ReportControlName.Line (CanvasCurrentX, CanvasCurrentY)-Step(-XPixles, XPixles), 0, BF
               End If                     'Next Column
               CanvasCurrentY = CanvasCurrentY + XPixles
            Next i1 'Next Row
            CanvasCurrentY = CanvasTop
            CanvasCurrentX = CanvasCurrentX - XPixles
        ElseIf Orientation = 270 Then
            CanvasCurrentY = CanvasTop + CanvasHeight
            For i1 = 0 To cols - 1
               If resultBitmap(i1, j1) = 0 Then 'it is a "WHITE" square
                 ReportControlName.Line (CanvasCurrentX, CanvasCurrentY)-Step(XPixles, -XPixles), 16777215, BF
               Else                       'it is a "BLACK" square
                 ReportControlName.Line (CanvasCurrentX, CanvasCurrentY)-Step(XPixles, -XPixles), 0, BF
               End If                     'Next Column
               CanvasCurrentY = CanvasCurrentY - XPixles
            Next i1 'Next Row
            CanvasCurrentX = CanvasCurrentX + XPixles
        Else
            CanvasCurrentX = TextControlName.Left
            For i1 = 0 To cols - 1
               If resultBitmap(i1, j1) = 0 Then 'it is a "WHITE" square
                 ReportControlName.Line (CanvasCurrentX, CanvasCurrentY)-Step(XPixles, -XPixles), 16777215, BF
               Else                       'it is a "BLACK" square
                 ReportControlName.Line (CanvasCurrentX, CanvasCurrentY)-Step(XPixles, -XPixles), 0, BF
               End If                     'Next Column
               CanvasCurrentX = CanvasCurrentX + XPixles
            Next i1 'Next Row
            CanvasCurrentY = CanvasCurrentY + XPixles
        End If
    Next j1
End Function


